/*** 1.   ũƮ ***/

SELECT std_no
	, CASE WHEN std_no <= 1000 THEN '1'
	  WHEN std_no <= 2000 THEN '2'
	  WHEN std_no <= 3000 THEN '3'
	  WHEN std_no <= 4000 THEN '4'
	  ELSE '5' END class_cd
     , CONVERT(NVARCHAR(36),NEWID()) code INTO TB_Std
FROM (
	SELECT ROW_NUMBER() OVER ( ORDER BY a.number) std_no
	FROM master..spt_values a , master..spt_values b
	WHERE a.type = 'P'
	AND a.number BETWEEN 1 AND 1000  
	AND b.type = 'P'
	AND b.number BETWEEN 1 AND 5
) c

SELECT a.std_no
	, CHAR(b.number+64) sbjt_cd
	, CASE WHEN a.std_no = 1 THEN 100
	  ELSE CONVERT(INT,RIGHT(std_no * ASCII(CONVERT(NVARCHAR(36), NEWID())), 2)) 
	  END point 
INTO TB_Point
FROM TB_Std a , master..spt_values b
WHERE b.type = 'P' AND b.number BETWEEN 1 AND 26

CREATE INDEX NIDX01_Std ON TB_Std ( class_cd , std_no ) 
GO


/*** 2. [AS-IS] SQL    ȹ ***/

WITH WT_Rank
AS (SELECT s.class_cd, s.std_no, SUM(p.point) total_point
    FROM TB_Std s INNER JOIN TB_Point p
    ON s.std_no = p.std_no
    WHERE s.class_cd = '1'
    GROUP BY s.class_cd, s.std_no)

SELECT class_cd, std_no, std_rank, total_point, total_std_cnt
FROM (SELECT class_cd, std_no, total_point
	      , RANK() OVER (ORDER BY total_point DESC) std_rank 
	 FROM WT_Rank
) a, (SELECT COUNT(*) total_std_cnt FROM WT_Rank) b
WHERE a.std_rank = 1 
GO


/*** 6. [TO-BE]   ***/

SELECT s.class_cd, s.std_no, SUM(p.point) total_point 
INTO #TMP_Rank 
FROM TB_Std s INNER JOIN TB_Point p
ON s.std_no = p.std_no
WHERE s.class_cd = '1'
GROUP BY s.class_cd, s.std_no

SELECT class_cd, std_no, std_rank, total_point, total_std_cnt
FROM (SELECT class_cd, std_no, total_point
	      , RANK() OVER ( ORDER BY total_point DESC) std_rank
	 FROM #TMP_Rank
) a, (SELECT COUNT(*) total_std_cnt FROM #TMP_Rank) b
WHERE a.std_rank = 1 
GO